/*
Tabellen in der Datenbank "const dbName = 'KiMuDienste.db';" aus main.dart
anlegen, sofern noch nicht geschehen.

Die Datenbank ist im Format "SQLite format 3" angelegt.

18.01.2026 M.G. Häupler

*/
CREATE TABLE IF NOT EXISTS Benutzer(
  benutzer_id INTEGER PRIMARY KEY AUTOINCREMENT,
  benutzer_default INTEGER NOT NULL DEFAULT 0,
  vorname VARCHAR(128) NOT NULL,
  nachname VARCHAR(128) NOT NULL,
  name VARCHAR(256) NOT NULL,
  strasse VARCHAR(70),
  ort VARCHAR(70),
  pruefung VARCHAR(64) NOT NULL DEFAULT 'ohne Prüfung',
  pruefungsjahr INTEGER,
  stufe INTEGER,
  berufstart INTEGER,
  organist INTEGER DEFAULT 1,
  chorleiter INTEGER DEFAULT 0,
  telefon VARCHAR(100) DEFAULT '',
  email VARCHAR(128),
  stundenSatz REAL,
  bemerkung TEXT,
  sonstiges TEXT
  );

CREATE TABLE IF NOT EXISTS EntgeltTabelle(
  entgelt_id INTEGER PRIMARY KEY AUTOINCREMENT,
  gruppe VARCHAR(1) NOT NULL,
  artDesDienstes VARCHAR(128),
  stundenFaktor REAL,
  backgroundcolor INTEGER,
  textcolor INTEGER,
  entgeltDefault INTEGER NOT NULL DEFAULT 0
);

CREATE TABLE IF NOT EXISTS Gemeinde (
  gemeinde_id INTEGER PRIMARY KEY AUTOINCREMENT,
  gemeindedefault INTEGER NOT NULL DEFAULT 0,
  name VARCHAR(128) NOT NULL,
  ort VARCHAR(128),
  strasse VARCHAR(128),
  km VARCHAR(64),
  email VARCHAR(128),
  telefon VARCHAR(128),
  mobilfunk VARCHAR(128),
  taetigseit INTEGER,
  taetigals VARCHAR(128),
  vereinbarung TEXT,
  bemerkung TEXT,
  sonstiges TEXT,
  gemeinde_benutzer INTEGER
);

CREATE TABLE IF NOT EXISTS Einstellungen (
  einstellungen_id INTEGER PRIMARY KEY AUTOINCREMENT,
  datumVorauswahl INTEGER,
  vonZeitVorauswahl INTEGER,
  bisZeitVorauswahl INTEGER,
  langEintragPunktMittig INTEGER,
  scrollToEnd INTEGER
);

CREATE TABLE IF NOT EXISTS Dienste (
  dienste_id INTEGER PRIMARY KEY AUTOINCREMENT,
  benutzer_id INTEGER,
  gemeinde_id INTEGER,
  entgelt_id INTEGER,
  datum_von INTEGER,
  datum_bis INTEGER,
  stundenGenau INTEGER,
  km VARCHAR(64),
  bemerkung TEXT
);